clear all, clc

%add folder path and filename
myfolder='';
filename_before ='before';
filename_after = 'after';
pixelsize=3000/1844; %in nm


%load file in
A_before=readmatrix([myfolder,'/',filename_before,'.csv']);
B_before=autocorr(A_before(:,2),length(A_before(:,2))-1);

compixelsize=['pixelsize=', num2str(pixelsize),' ', 'nm'];

A_after=readmatrix([myfolder,'/',filename_after,'.csv']);
B_after=autocorr(A_after(:,2),length(A_after(:,2))-1);

compixelsize=['pixelsize=', num2str(pixelsize),' ', 'nm'];


plot([1:length(B_before)]'*pixelsize,B_before(:,1),'Color', 'magenta');
hold on

plot([1:length(B_after)]'*pixelsize,B_after(:,1),'Color', 'cyan');

legend(filename_before, filename_after);




hold off

xlabel('Lag (nm)');
ylabel('Autocorrelation function');
ylim([-0.5, 1])
xlim([0,1000])
xticks(0:200:1000)
title({'Autocorrelation of localisations of GPI-GFP'});

set(gca,'FontSize', 15)


%save figure to path
saveas(figure(1),fullfile(myfolder,['ACF-lag[nm]-plot','_',compixelsize,'.png']))
saveas(figure(1),fullfile(myfolder,['ACF-lag[nm]-plot','_',compixelsize,'.fig']))
saveas(figure(1),fullfile(myfolder,['ACF-lag[nm]-plot','_',compixelsize,'.pdf']))

%save .csv to path
G=[[1:length(B_before)]'*pixelsize,B_before(:,1),B_after(:,1)];

dlmwrite(fullfile(myfolder,['before_after_ACF-lag[nm]-plot','_',compixelsize,'.csv']),G);

disp('Done');